<x-app-layout>
    <x-slot name="header">
        CIty
    </x-slot>

    <!-- Row -->
    <div class="row">
        <div class="col-md-10">
            <div class="card">
                <div class="card-header">
                    <div class="card-title">
                        @isset($city->id)
                        Edit City
                        @else
                        Add New City
                        @endisset
                    </div>
                </div>
                <form action="
                    @isset($city->id)
                        {{ route('admin.location.city.update', [$state->id, $city->id]) }}
                    @else
                        {{ route('admin.location.city.store', $state->id) }}
                    @endisset
                    " method="post" enctype="multipart/form-data">
                    <div class="card-body">
                        @isset($city->id)
                        @method('PUT')
                        @endisset
                        @csrf
                        <div class="row mb-4">
                            <label class="col-md-3 form-label" id="state_id">State :</label>
                            <div class="">
                                <select name="state_id" id="state_id" class="form-control @error('name') is-invalid @enderror">
                                    <option value="">Select State</option>
                                    @foreach ($states as $ste)
                                    <option value="{{ $ste->id }}" @selected(old('state_id', $city->state_id) == $ste->id || $state->id == $ste->id)>{{ $ste->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            @error('state_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="row mb-4">
                            <label class="col-md-3 form-label" id="name">City Name :</label>
                            <div class="">
                                <input type="search" class="form-control @error('name') is-invalid @enderror"
                                    name="name" value="{{ old('name', $city->name) }}" placeholder="City Name">
                            </div>
                            @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="row mb-4">
                            <label class="col-md-3 form-label" id="code">City Code :</label>
                            <div class="">
                                <input type="search" class="form-control @error('code') is-invalid @enderror"
                                    name="code" value="{{ old('code', $city->code) }}" placeholder="City code">
                            </div>
                            @error('code')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <label class="custom-switch form-switch me-5">
                            <input type="checkbox" name="status" value="1" class="custom-switch-input" {{ old('status',
                                $city->status) == 1 ? 'checked' : '' }}>
                            <span class="custom-switch-indicator custom-switch-indicator-lg"></span>
                            <span class="custom-switch-description">Status</span>
                        </label>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">Save</button>
                        <a href="{{route('admin.location.city.index', $state->id)}}"
                            class="btn btn-default float-end">Discard</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- End Row -->
</x-app-layout>
